function batt = scaleBatt(batt, rescaled_batt_energy, rescaled_batt_voltage)
arguments
    batt
    rescaled_batt_energy
    rescaled_batt_voltage = [];
end
%scaleBattMap
% Create and scale an batt map
%   rescaled_batt_energy: kWh
%   rescaled_batt_voltage (optional): V

if isempty(rescaled_batt_voltage)
    numSeries = 1;
else
    numSeries =  rescaled_batt_voltage / batt.nomVolt;
end

% Scaling factor
rescaled_batt_capacity = rescaled_batt_energy * 1e3 / batt.nomVolt / numSeries;
numParallel = rescaled_batt_capacity / batt.nomCap;

% Number of cells 
batt.numParallel = numParallel;
batt.numSeries = numSeries;


% Rescale main data
batt.nomEnergy = rescaled_batt_energy;
batt.nomVolt = batt.nomVolt * numSeries;

batt.nomCap = rescaled_batt_capacity;
batt.minCurr = batt.minCurr * numParallel;
batt.maxCurr = batt.maxCurr * numParallel;
batt.mass = batt.mass * numSeries * numParallel;

% Rescale Voc and Req characteristics
batt.eqRes.Values = batt.eqRes.Values * numSeries / numParallel;
batt.ocVolt.Values = batt.ocVolt.Values * numSeries;

end
